/*********************************************************************/
/* Project Name: SCI.mcp                                             */
/* Source fle name: SCI.c                                            */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: SCI                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: The SCI module is configured to work at 9600bps,     */
/* in 8-bit mode and normal operation. When an interrupt is          */
/* generated the received data is display on PTE port and one byte   */
/* is send by SCI                                                    */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      

#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned char UINT8;

/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
 SOPT1 = 0x23;          /* Watchdog disable. Stop Mode Enable. Background Pin enable. RESET pin enable */  
 SCGC1 = 0x01;          /* Bus Clock to the SCI1 module is enable */
 SCGC2 = 0x00;          /* Disable Bus clock to unused peripherals */
}

void GPIO_Init(void) { 
  
  PTCDD = (UINT8) (PTCD | 0x3F);          /* Configure PTC0-PTC6 as outputs */
  PTEDD = (UINT8) (PTED | 0xC0);          /* Configure PTE6 and PTE7 pins as outputs */
  PTCD = 0x3F;           /* Put 1's in port C in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in port E port in order to turn off the LEDs */
}

void SCI_configuration (void) {
  
  SCI1C1 = 0x00;        /* 8-bit mode. Normal operation */
  SCI1C2 = 0x2C;        /* Receiver interrupt enable. Transmitter and receiver enable */
  SCI1C3 = 0x00;        /* Disable all errors interrupts */
  SCI1BDL = 0x1A;       /* This register and the SCI1BDH are used to configure the SCI baud rate */
  SCI1BDH = 0x00;       /*                    BUSCLK               4MHz                */
                        /* Baud rate = -------------------- = ------------ = 9600bps   */
}                       /*               [SBR12:SBR0] x 16        26 x 16              */

/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */      
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  SCI_configuration();  /* Function that initializes the SCI module */

  EnableInterrupts; /* enable interrupts */
      
  for(;;) {
  
  } /* loop forever */
  /* please make sure that you never leave this function */
}

void interrupt VectorNumber_Vsci1rx SCI_RX_ISR(void) {

 UINT8 temp;
 SCI1S1_RDRF = 0;       /* Receive interrupt disable */
 temp = SCI1D;          /* Display on PTE the received data from SCI */
 PTED = (UINT8) (temp & 0xC0);         /* Move the received value to port E */
 PTCD = (UINT8) (temp & 0x3F);         /* Move the received value to port C */

 while (SCI1S1_TDRE == 0);  /* Wait for the transmitter to be empty */
 SCI1D = '1';               /* Send a character by SCI */
}